## Sid Meier's Civilization 4
## Copyright Firaxis Games 2005
## Hero Advisor for Sanguo Mod
# Thanks to Requies and Elhoim from CivFanatics for this interface mod

from CvPythonExtensions import *
import CvUtil
import ScreenInput
import CvScreenEnums

import BugUtil
import WidgetUtil

# globals
gc = CyGlobalContext()
ArtFileMgr = CyArtFileMgr()
localText = CyTranslator()

NUM_HERO_SCREENS = 1

class CvHeroAdvisor:
	"Hero Advisor Screen"

	def __init__(self):
		self.iHero = -1
		self.iScreen = -1
		self.nWidgetCount = 0
		self.nLineCount = 0
		self.WIDGET_ID = "HeroAdvisorWidget"
		self.LINE_ID = "HeroAdvisorLine"
		self.SCREEN_NAME = "HeroAdvisor"
		self.DEBUG_DROPDOWN_ID =  "HeroAdvisorDropdownWidget"
		self.EXIT_ID = "HeroAdvisorExitWidget"
		self.BACKGROUND_ID = "HeroAdvisorBackground"
		self.PersuadeWidget = WidgetUtil.createWidget("WIDGET_PERSUADE")
		self.ExecuteWidget = WidgetUtil.createWidget("WIDGET_EXECUTE")
		self.ReleaseWidget = WidgetUtil.createWidget("WIDGET_RELEASE")
		self.X_SCREEN = 500
		self.Y_SCREEN = 396
		self.W_SCREEN = 960
		self.H_SCREEN = 768
		self.Y_TITLE = 8
		self.X_EXIT = 994
		self.Y_EXIT = 726
		self.X_LEADER = 80
		self.Y_LEADER = 115
		self.H_LEADER = 64
		self.W_LEADER = 64
		self.X_LINK = 50
		self.DX_LINK = 220
		self.Y_LINK = 726

		self.X_LEGEND = 20
		self.Y_LEGEND = 540
		self.H_LEGEND = 160
		self.W_LEGEND = 160
		self.MARGIN_LEGEND = 10

		self.X_LEADER_CIRCLE_TOP = self.X_SCREEN + 10
		self.Y_LEADER_CIRCLE_TOP = 87

		self.RADIUS_LEADER_ARC = 480
		self.LINE_WIDTH = 6
		self.BUTTON_SIZE = 64

		self.iSelectedLeader = -1
		self.iActiveLeader = -1
		self.listSelectedLeaders = []
		self.iShiftKeyDown = 0

		self.GLANCE_HEADER = "HeroAdvisorGlanceHeader"
		self.GLANCE_BUTTON = "HeroAdvisorPlusMinus"
		self.X_LINK = 0
		self.Y_LINK = 726

		self.X_GLANCE_OFFSET = 10
		self.Y_GLANCE_OFFSET = 3
		self.GLANCE_BUTTON_SIZE = 46
		self.PLUS_MINUS_SIZE = 25
		self.bGlancePlus = True

		self.INFO_BORDER = 10

		self.TITLE_HEIGHT = 24
		self.TABLE_CONTROL_HEIGHT = 24
		self.RESOURCE_ICON_SIZE = 34
		self.SCROLL_TABLE_UP = 1
		self.SCROLL_TABLE_DOWN = 2

		self.X_HERO_PANE = self.X_SCREEN + 5
		self.W_HERO_PANE = 130
		self.H_HERO_PANE = self.H_SCREEN - 95
		self.Y_HERO_PANE = self.Y_SCREEN + 50

		self.X_UNIT_PANE = self.X_HERO_PANE + self.W_HERO_PANE + 5
		self.Y_UNIT_PANE = self.Y_HERO_PANE
		self.W_UNIT_PANE = 255
		self.H_UNIT_PANE = 255

		self.W_ICON = 240
		self.H_ICON = 240
		self.X_ICON = self.X_UNIT_PANE + (self.W_UNIT_PANE - self.W_ICON) / 2
		self.Y_ICON = self.Y_UNIT_PANE + (self.H_UNIT_PANE - self.H_ICON) / 2 + 3

		self.ICON_SIZE = 64
		self.BUTTON_SIZE = 64
		self.PROMOTION_ICON_SIZE = 32

		self.X_UNIT_ANIMATION = self.X_UNIT_PANE + self.W_UNIT_PANE + 10
		self.W_UNIT_ANIMATION = 75
		self.Y_UNIT_ANIMATION = self.Y_UNIT_PANE + 7
		self.H_UNIT_ANIMATION = 119
		self.X_ROTATION_UNIT_ANIMATION = -20
		self.Z_ROTATION_UNIT_ANIMATION = 30
		self.SCALE_ANIMATION = 1.0

		self.X_UNITCOMBAT_PANE = self.X_UNIT_ANIMATION + self.W_UNIT_ANIMATION + 10
		self.Y_UNITCOMBAT_PANE = self.Y_UNIT_PANE + 10
		self.W_UNITCOMBAT_PANE = 280
		self.H_UNITCOMBAT_PANE = 110

		self.X_CIV_PANE = self.X_UNIT_ANIMATION
		self.Y_CIV_PANE = self.Y_UNIT_ANIMATION + self.H_UNIT_ANIMATION + 10
		self.W_CIV_PANE = self.W_UNIT_ANIMATION + 10 + self.W_UNITCOMBAT_PANE - 100
		self.H_CIV_PANE = 119

		self.X_BELIEF_PANE = self.X_CIV_PANE + self.W_CIV_PANE + 10
		self.Y_BELIEF_PANE = self.Y_CIV_PANE
		self.W_BELIEF_PANE = self.W_UNIT_ANIMATION + self.W_UNITCOMBAT_PANE - self.W_CIV_PANE
		self.H_BELIEF_PANE = 119

		self.X_SPECIAL_PANE = self.X_UNIT_PANE
		self.Y_SPECIAL_PANE = self.Y_UNIT_PANE + self.H_UNIT_PANE + 10
		self.W_SPECIAL_PANE = 280
		self.H_SPECIAL_PANE = 110

		self.X_CURRENT_PROMO_PANE = self.X_UNIT_PANE
		self.Y_CURRENT_PROMO_PANE = self.Y_SPECIAL_PANE + self.H_SPECIAL_PANE + 10
		self.W_CURRENT_PROMO_PANE = 280
		self.H_CURRENT_PROMO_PANE = 110

		self.X_POTENTIAL_PROMO_PANE = self.X_UNIT_PANE
		self.Y_POTENTIAL_PROMO_PANE = self.Y_CURRENT_PROMO_PANE + self.H_CURRENT_PROMO_PANE + 10
		self.W_POTENTIAL_PROMO_PANE = 280
		self.H_POTENTIAL_PROMO_PANE = self.Y_HERO_PANE + self.H_HERO_PANE - self.Y_POTENTIAL_PROMO_PANE

		self.X_HISTORY_PANE = self.X_SPECIAL_PANE + self.W_SPECIAL_PANE + 10
		self.Y_HISTORY_PANE = self.Y_SPECIAL_PANE
		self.W_HISTORY_PANE = self.X_SCREEN + self.W_SCREEN - self.X_HISTORY_PANE - 20
		self.H_HISTORY_PANE = self.Y_HERO_PANE + self.H_HERO_PANE - self.Y_HISTORY_PANE

		self.WidgetNames = ["HeroPanel", "PortraitPanel", "Portrait", "Stats", "BeliefPanel", "UnitCombatLevel", "CivPanel", "HistoryPanel", "CurrentPromotionPanel", "PotentialPromotionPanel", "HelpPanel"]

		self.SCREEN_DICT = {
			"RECRUITMENT": 0,
			"INFO"       : 1,
			"PRISONER"   : 2,
			}

		self.REV_SCREEN_DICT = {}

		for key, value in self.SCREEN_DICT.items():
			self.REV_SCREEN_DICT[value] = key

		self.DRAW_DICT = {
			"RECRUITMENT": self.drawRecruitment,
			"INFO"       : self.drawInfo,
			"PRISONER"   : self.drawPrisoner,
			}

		self.TXT_KEY_DICT = {
			"RECRUITMENT": "TXT_KEY_HERO_ADVISOR_RECRUITMENT",
			"INFO"       : "TXT_KEY_HERO_ADVISOR_INFO",
			"PRISONER"   : "TXT_KEY_HERO_ADVISOR_PRISONER",
			}

		self.ORDER_LIST = ["RECRUITMENT", "INFO", "PRISONER"]

		self.iDefaultScreen = self.SCREEN_DICT["RECRUITMENT"]

		self.UnitCombatEnum = {}

		self.UnitCombatInfo = {}

		self.CombatLevelSign = {0 : '/',
					1 : 'D',
					2 : 'C',
					3 : 'B',
					4 : 'A',
					5 : 'S',
					-1: '/'}

	def killScreen(self):
		if (self.iScreen >= 0):
			screen = self.getScreen()
			screen.hideScreen()
			self.iScreen = -1
		return

	def getScreen(self):
		return CyGInterfaceScreen(self.SCREEN_NAME + str(self.iScreen), CvScreenEnums.HERO_ADVISOR)

	def interfaceScreen (self, iScreen):

		if (iScreen < 0):
			if (self.iScreen < 0):
				iScreen = self.iDefaultScreen
			else:
				iScreen = self.iScreen

		self.EXIT_TEXT = u"<font=4>" + localText.getText("TXT_KEY_PEDIA_SCREEN_EXIT", ()).upper() + u"</font>"
		self.SCREEN_TITLE = u"<font=4b>" + localText.getText("TXT_KEY_HERO_ADVISOR_TITLE", ()).upper() + u"</font>"

		if (self.iScreen != iScreen):
			self.killScreen()
			self.iScreen = iScreen

		screen = self.getScreen()
		if screen.isActive():
			return
		screen.setRenderInterfaceOnly(True);
		screen.showScreen( PopupStates.POPUPSTATE_IMMEDIATE, False)

		self.iActiveLeader = CyGame().getActivePlayer()
		self.objActiveLeader = gc.getPlayer(self.iActiveLeader)
		self.iActiveTeam = self.objActiveLeader.getTeam()
		self.objActiveTeam = gc.getTeam(self.iActiveTeam)
		self.iSelectedLeader = self.iActiveLeader
		self.listSelectedLeaders = []

		self.W_SCREEN = 1024
		self.X_SCREEN = (screen.getXResolution() - self.W_SCREEN) / 2
		self.L_SCREEN = 20

		self.X_EXIT = self.W_SCREEN - 30

		self.DX_LINK = (self.X_EXIT - self.X_LINK) / (len (self.SCREEN_DICT) + 1)

		self.Y_EXIT = self.H_SCREEN - 42
		self.Y_LINK = self.H_SCREEN - 42
		self.Y_BOTTOM_PANEL = self.H_SCREEN - 55

		self.X_HERO_PANE = 5
		self.W_HERO_PANE = 130
		self.H_HERO_PANE = self.H_SCREEN - 170
		self.Y_HERO_PANE = 110 #self.Y_SCREEN + 50

		self.X_UNIT_PANE = self.X_HERO_PANE + self.W_HERO_PANE + 5
		self.Y_UNIT_PANE = self.Y_HERO_PANE
		self.W_UNIT_PANE = 255
		self.H_UNIT_PANE = 255

		self.W_ICON = 240
		self.H_ICON = 240
		self.X_ICON = self.X_UNIT_PANE + (self.W_UNIT_PANE - self.W_ICON) / 2
		self.Y_ICON = self.Y_UNIT_PANE + (self.H_UNIT_PANE - self.H_ICON) / 2 + 3

		self.ICON_SIZE = 64
		self.BUTTON_SIZE = 64
		self.PROMOTION_ICON_SIZE = 32

		self.X_UNIT_ANIMATION = self.X_UNIT_PANE + self.W_UNIT_PANE + 10
		self.W_UNIT_ANIMATION = 150
		self.Y_UNIT_ANIMATION = self.Y_UNIT_PANE + 7
		self.H_UNIT_ANIMATION = 119
		self.X_ROTATION_UNIT_ANIMATION = -20
		self.Z_ROTATION_UNIT_ANIMATION = 30
		self.SCALE_ANIMATION = 1.0

		self.X_UNITCOMBAT_PANE = self.X_UNIT_ANIMATION + self.W_UNIT_ANIMATION + 10
		self.Y_UNITCOMBAT_PANE = self.Y_UNIT_PANE + 10
		self.W_UNITCOMBAT_PANE = 205
		self.H_UNITCOMBAT_PANE = 110

		self.X_CIV_PANE = self.X_UNIT_ANIMATION
		self.Y_CIV_PANE = self.Y_UNIT_ANIMATION + self.H_UNIT_ANIMATION + 10
		self.W_CIV_PANE = self.W_UNIT_ANIMATION + 10 + self.W_UNITCOMBAT_PANE - 100
		self.H_CIV_PANE = 119

		self.X_BELIEF_PANE = self.X_CIV_PANE + self.W_CIV_PANE + 10
		self.Y_BELIEF_PANE = self.Y_CIV_PANE
		self.W_BELIEF_PANE = self.W_UNIT_ANIMATION + self.W_UNITCOMBAT_PANE - self.W_CIV_PANE
		self.H_BELIEF_PANE = 119

		self.X_SPECIAL_PANE = self.X_UNIT_PANE
		self.Y_SPECIAL_PANE = self.Y_UNIT_PANE + self.H_UNIT_PANE + 10
		self.W_SPECIAL_PANE = 280
		self.H_SPECIAL_PANE = 110

		self.X_CURRENT_PROMO_PANE = self.X_UNIT_PANE
		self.Y_CURRENT_PROMO_PANE = self.Y_SPECIAL_PANE + self.H_SPECIAL_PANE + 10
		self.W_CURRENT_PROMO_PANE = 280
		self.H_CURRENT_PROMO_PANE = 110

		self.X_POTENTIAL_PROMO_PANE = self.X_UNIT_PANE
		self.Y_POTENTIAL_PROMO_PANE = self.Y_CURRENT_PROMO_PANE + self.H_CURRENT_PROMO_PANE + 10
		self.W_POTENTIAL_PROMO_PANE = 280
		self.H_POTENTIAL_PROMO_PANE = self.Y_HERO_PANE + self.H_HERO_PANE - self.Y_POTENTIAL_PROMO_PANE

		self.X_HISTORY_PANE = self.X_SPECIAL_PANE + self.W_SPECIAL_PANE + 10
		self.Y_HISTORY_PANE = self.Y_SPECIAL_PANE
		self.W_HISTORY_PANE = self.W_SCREEN - self.X_HISTORY_PANE - 20
		self.H_HISTORY_PANE = self.Y_HERO_PANE + self.H_HERO_PANE - self.Y_HISTORY_PANE

		self.PrisonerHeroes = []

		# Set the background and exit button, and show the screen
		screen.setDimensions(self.X_SCREEN, 0, self.W_SCREEN, self.H_SCREEN)
		screen.addDrawControl(self.BACKGROUND_ID, ArtFileMgr.getInterfaceArtInfo("SCREEN_BG_OPAQUE").getPath(), 0, 0, self.W_SCREEN, self.H_SCREEN, WidgetTypes.WIDGET_GENERAL, -1, -1 )
		screen.addPanel( "TopPanel", u"", u"", True, False, 0, 0, self.W_SCREEN, 55, PanelStyles.PANEL_STYLE_TOPBAR )
		screen.addPanel( "BottomPanel", u"", u"", True, False, 0, self.Y_BOTTOM_PANEL, self.W_SCREEN, 55, PanelStyles.PANEL_STYLE_BOTTOMBAR )

		screen.showWindowBackground(False)
		screen.setText(self.EXIT_ID, "", self.EXIT_TEXT, CvUtil.FONT_RIGHT_JUSTIFY, self.X_EXIT, self.Y_EXIT, 0, FontTypes.TITLE_FONT, WidgetTypes.WIDGET_CLOSE_SCREEN, -1, -1 )

		self.nWidgetCount = 0
		self.nLineCount = 0

		if (CyGame().isDebugMode()):
			self.szDropdownName = self.getWidgetName(self.DEBUG_DROPDOWN_ID)
			screen.addDropDownBoxGFC(self.szDropdownName, 22, 12, 300, WidgetTypes.WIDGET_GENERAL, -1, -1, FontTypes.GAME_FONT)
			for j in range(gc.getMAX_PLAYERS()):
				if (gc.getPlayer(j).isAlive()):
					screen.addPullDownString(self.szDropdownName, gc.getPlayer(j).getName(), j, j, False )

		self.UnitCombatEnum = {'MELEE'    :    gc.getInfoTypeForString("UNITCOMBAT_MELEE"),
				       'MOUNTED'  :    gc.getInfoTypeForString("UNITCOMBAT_MOUNTED"),
				       'ARCHER'   :    gc.getInfoTypeForString("UNITCOMBAT_ARCHER"),
				       'SIEGE'    :    gc.getInfoTypeForString("UNITCOMBAT_SIEGE"),
				       'NAVAL'    :    gc.getInfoTypeForString("UNITCOMBAT_NAVAL")}

		self.UnitCombatInfo = {'MELEE'    :    gc.getUnitCombatInfo(gc.getInfoTypeForString("UNITCOMBAT_MELEE")),
				       'MOUNTED'  :    gc.getUnitCombatInfo(gc.getInfoTypeForString("UNITCOMBAT_MOUNTED")),
				       'ARCHER'   :    gc.getUnitCombatInfo(gc.getInfoTypeForString("UNITCOMBAT_ARCHER")),
				       'SIEGE'    :    gc.getUnitCombatInfo(gc.getInfoTypeForString("UNITCOMBAT_SIEGE")),
				       'NAVAL'    :    gc.getUnitCombatInfo(gc.getInfoTypeForString("UNITCOMBAT_NAVAL"))}

		self.drawContents()

	def drawContents(self):

		if (self.iScreen < 0):
			return

		self.deleteAllWidgets()

		screen = self.getScreen()

		# Header...
		screen.setLabel(self.getNextWidgetName(), "", self.SCREEN_TITLE, CvUtil.FONT_CENTER_JUSTIFY, self.W_SCREEN / 2, self.Y_TITLE, 0, FontTypes.TITLE_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1 )

		if (self.REV_SCREEN_DICT.has_key(self.iScreen)):
			self.DRAW_DICT[self.REV_SCREEN_DICT[self.iScreen]] ()
		else:
			return

		# Link to other Hero advisor screens
		xLink = self.DX_LINK / 2;

		for i in range (len (self.ORDER_LIST)):
			szTextId = "SubScreen" + str(i)
			szScreen = self.ORDER_LIST[i]

			if (self.iScreen != self.SCREEN_DICT[szScreen]):
				screen.setText (szTextId, "", u"<font=4>" + localText.getText (self.TXT_KEY_DICT[szScreen], ()).upper() + u"</font>", CvUtil.FONT_CENTER_JUSTIFY, xLink, self.Y_LINK, 0, FontTypes.TITLE_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)
			else:
				screen.setText (szTextId, "", u"<font=4>" + localText.getColorText (self.TXT_KEY_DICT[szScreen], (), gc.getInfoTypeForString ("COLOR_YELLOW")).upper() + u"</font>", CvUtil.FONT_CENTER_JUSTIFY, xLink, self.Y_LINK, 0, FontTypes.TITLE_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)
			xLink += self.DX_LINK

	def drawRecruitment(self):
		screen = self.getScreen()

		for sWidget in self.WidgetNames:
			screen.deleteWidget(sWidget)

		# Some spacing variables to help with the layout
		iOutsideGap = 6
		iInsideGap = 10
		iBetweenGap = iOutsideGap - 2
		iHeaderHeight = 32

		# Header
		headerBackgroundPanelName = "HeaderBackground"
		iLeft = iOutsideGap
		iTop = 50 + iOutsideGap
		iWidth = self.W_SCREEN - (2 * iOutsideGap)
		iHeight = iHeaderHeight + (2 * iInsideGap)
		screen.addPanel(headerBackgroundPanelName, "", "", True, False, iLeft, iTop, iWidth, iHeight, PanelStyles.PANEL_STYLE_MAIN)

		headerPanelName = "Header"
		iLeft = iLeft + iInsideGap
		iTop = iTop + iInsideGap
		iWidth = iWidth - (2 * iInsideGap)
		iHeight = iHeaderHeight
		screen.addPanel(headerPanelName, "", "", False, True, iLeft, iTop, iWidth, iHeight, PanelStyles.PANEL_STYLE_EMPTY)

		iOffset = 0

		for headerText in (BugUtil.getPlainText("TXT_KEY_HERO_ADVISOR_ABBR_HERO"),
						   BugUtil.getPlainText("TXT_KEY_HERO_ADVISOR_ABBR_DEBUT_STATUS"),
                                                   BugUtil.getPlainText("TXT_KEY_HERO_ADVISOR_ABBR_DEFAULT_CIV_LOYALTY"),
						   u"%c" %(CyGame().getSymbolID(FontSymbols.RELIGION_CHAR)),
						   BugUtil.getPlainText("TXT_KEY_HERO_ADVISOR_ABBR_DEFAULT_CIV"),
						   BugUtil.getPlainText("TXT_KEY_HERO_ADVISOR_ABBR_DEFAULT_CIV_LOYALTY"),
                                                   BugUtil.getPlainText("INTERFACE_PANE_LEADERSHIP"),
                                                   BugUtil.getPlainText("INTERFACE_PANE_MIGHT"),
						   BugUtil.getPlainText("TXT_KEY_HERO_ADVISOR_ABBR_GOLD"),
                                                   "",
						   BugUtil.getPlainText("TXT_KEY_HERO_ADVISOR_ABBR_ACTION")):
			itemName = self.getNextWidgetName()
##			screen.attachTextGFC(headerPanelName, itemName, headerText, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)
			screen.setTextAt(itemName, headerPanelName, headerText, CvUtil.FONT_CENTER_JUSTIFY, iLeft + iInsideGap + iOffset, iInsideGap, -0.1, FontTypes.GAME_FONT, WidgetTypes.WIDGET_HELP_RELIGION, -1, -1)
                        screen.setHitTest(itemName, HitTestTypes.HITTEST_NOHIT)
			iOffset = iOffset + 80

		# Main
		mainBackgroundPanelName = "MainBackground"
		iLeft = iOutsideGap
		iTop = iTop + iHeaderHeight + iInsideGap + iBetweenGap
		iWidth = self.W_SCREEN - (2 * iOutsideGap)
		iHeight = self.H_SCREEN - 100 - (2 * iOutsideGap) - iBetweenGap - iHeaderHeight - (2 * iInsideGap)
		screen.addPanel(mainBackgroundPanelName, "", "", True, False, iLeft, iTop, iWidth, iHeight, PanelStyles.PANEL_STYLE_MAIN)

		mainPanelName = "Main"
		iLeft = iLeft + iInsideGap
		iTop = iTop + iInsideGap
		iWidth = iWidth - (2 * iInsideGap)
		iHeight = iHeight - (4 * iInsideGap)
		screen.addScrollPanel(mainPanelName, "", iLeft, iTop, iWidth, iHeight, PanelStyles.PANEL_STYLE_EXTERNAL)
		screen.setActivation( mainPanelName, ActivationTypes.ACTIVATE_NORMAL )

		# loop through all other heroes and add their rows; show available first; order each group alphabetically (except random heroes, which are at the bottom, order themselves by the year of creation)
		lAvailableHeroes = {}
		lMaybeLaterHeroes = {}
		lEmployedHeroes = {}
		for iLoopHero in range(gc.getNumHeroInfos()):
			if self.objActiveLeader.canRecruitHero(iLoopHero, False):
				lAvailableHeroes[gc.getHeroInfo(iLoopHero).getType()] = iLoopHero
			elif gc.getGame().getHeroDebutStatus(iLoopHero) == -2 and gc.getGame().getHeroCapturePlayer(iLoopHero) == -1:
				lMaybeLaterHeroes[gc.getHeroInfo(iLoopHero).getType()] = iLoopHero
			elif gc.getGame().getHeroDebutStatus(iLoopHero) >= 0 and gc.getGame().getHeroCapturePlayer(iLoopHero) == -1:
				lEmployedHeroes[gc.getHeroInfo(iLoopHero).getType()] = iLoopHero

		iCount = 0
		lTempList = lAvailableHeroes.keys()
		lTempList.sort()
		for sType in lTempList:
			self.drawRecruitmentRow(screen, mainPanelName, lAvailableHeroes[sType], PanelStyles.PANEL_STYLE_STANDARD, -4, iCount)
			iCount += 1
		lTempList = lMaybeLaterHeroes.keys()
		lTempList.sort()
		for sType in lTempList:
			self.drawRecruitmentRow(screen, mainPanelName, lMaybeLaterHeroes[sType], PanelStyles.PANEL_STYLE_STANDARD, -2, iCount)
			iCount += 1
		lTempList = lEmployedHeroes.keys()
		lTempList.sort()
		for sType in lTempList:
			self.drawRecruitmentRow(screen, mainPanelName, lEmployedHeroes[sType], PanelStyles.PANEL_STYLE_STANDARD, gc.getGame().getHeroDebutStatus(lEmployedHeroes[sType]), iCount)
			iCount += 1


	def drawRecruitmentRow (self, screen, mainPanelName, iLoopHero, ePanelStyle, iDebutStatus, iCount):

		objHero = gc.getHeroInfo (iLoopHero)

		iOutsideGap = 6
		iInsideGap = 10
		iBetweenGap = iOutsideGap - 2
		iHeaderHeight = 32

		iLeft = iOutsideGap + iInsideGap
		iTop = 50 + iOutsideGap + iHeaderHeight + iInsideGap * 2 + iBetweenGap
		iWidth = self.W_SCREEN - (4 * iOutsideGap)
		iRowHeight = 48

		iOffSet = 0

		# Hero panel
		infoPanelName = self.getNextWidgetName()
		szHeroLable = "" # objLoopPlayer.getName()
		screen.attachPanelAt( mainPanelName, infoPanelName, szHeroLable, "", False, False, ePanelStyle, 0, iRowHeight * iCount, iWidth - iOutsideGap * 7, iRowHeight, WidgetTypes.WIDGET_GENERAL, -1, -1 )
		screen.setActivation( infoPanelName, ActivationTypes.ACTIVATE_MIMICPARENTFOCUS)
		screen.hide(infoPanelName)

		itemName = self.getNextWidgetName()

		screen.setImageButtonAt(itemName, infoPanelName, objHero.getButton(), 0, 0, 48, 48, WidgetTypes.WIDGET_PEDIA_JUMP_TO_HERO, iLoopHero, -1)
                iOffSet += 80

		# Debut Status
		itemName = self.getNextWidgetName()
		iX_Text = 42
		if CyGame().getCurrentLanguage() == 5:
			iX_Text = 52
		if iDebutStatus == -4 or iDebutStatus == -2:
			szAttStr = "<font=2>" + BugUtil.getPlainText("TXT_KEY_HERO_ADVISOR_AVAILABLE") + "</font>"
			screen.setTextAt(itemName, infoPanelName, szAttStr, CvUtil.FONT_CENTER_JUSTIFY, iLeft + iX_Text, iInsideGap, -0.1, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)
		elif iDebutStatus == -1:
			szAttStr = "<font=2>" + BugUtil.getPlainText("TXT_KEY_HERO_ADVISOR_UNKNOWN") + "</font>"
			screen.setTextAt(itemName, infoPanelName, szAttStr, CvUtil.FONT_CENTER_JUSTIFY, iLeft + iX_Text, iInsideGap, -0.1, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)
		elif iDebutStatus == -3:
			szAttStr = "<font=2>" + BugUtil.getPlainText("TXT_KEY_HERO_ADVISOR_DECEASED") + "</font>"
			screen.setTextAt(itemName, infoPanelName, szAttStr, CvUtil.FONT_CENTER_JUSTIFY, iLeft + iX_Text, iInsideGap, -0.1, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)
		if iDebutStatus >= 0:
			if not self.objActiveTeam.isHasMet(gc.getPlayer(iDebutStatus).getTeam()) and not gc.getGame().isDebugMode():
				screen.setImageButtonAt(itemName, infoPanelName, gc.getDefineSTRING("LEADERHEAD_RANDOM"), iLeft + iOffSet, 0, 48, 48, WidgetTypes.WIDGET_GENERAL, -1, -1)
			else:
				screen.setImageButtonAt(itemName, infoPanelName, gc.getCivilizationInfo(gc.getPlayer(iDebutStatus).getCivilizationType()).getButton(), iLeft + iOffSet, 0, 48, 48, WidgetTypes.WIDGET_PEDIA_JUMP_TO_CIV, gc.getPlayer(iDebutStatus).getCivilizationType(), -1)
                iOffSet += 80

                # Loyalty to current faction
                itemName = self.getNextWidgetName()
		if iDebutStatus >= 0:
			iCivLoyalty = objHero.getCivilizationLoyalty(gc.getPlayer(iDebutStatus).getCivilizationType())
			szCivLoyalty = " %d" % (iCivLoyalty)
			if iCivLoyalty == 100:
				szCivLoyalty = localText.changeTextColor(szCivLoyalty, gc.getInfoTypeForString("COLOR_RED"))
		else:
			szCivLoyalty = ""
		screen.setTextAt(itemName, infoPanelName, szCivLoyalty, CvUtil.FONT_CENTER_JUSTIFY, iLeft + iOffSet, iInsideGap, -0.1, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)
		iOffSet += 80


		# Belief
		itemName = self.getNextWidgetName()
		nReligion = objHero.getBelief()
		if (nReligion != -1):
			objReligion = gc.getReligionInfo (nReligion)
			szHeroBelief = u"%c" %(objReligion.getChar())

			iBeliefStrength = objHero.getBeliefStrength()
			szColor = "COLOR_GREEN"
			szHeroBelief = localText.changeTextColor(szHeroBelief + " [%d]" % (iBeliefStrength), gc.getInfoTypeForString(szColor))
			szHeroBelief = "<font=2>" + szHeroBelief + "</font>"
		else:
			szHeroBelief = ""

		screen.setTextAt(itemName, infoPanelName, szHeroBelief, CvUtil.FONT_CENTER_JUSTIFY, iLeft + iOffSet, iInsideGap, -0.1, FontTypes.GAME_FONT, WidgetTypes.WIDGET_HELP_RELIGION, nReligion, -1)
		iOffSet += 80

		# Default Civilization
		itemName = self.getNextWidgetName()
		if gc.getGame().getCurrentDefaultCivilization(iLoopHero) != -1:
			screen.setImageButtonAt(itemName, infoPanelName, gc.getCivilizationInfo(gc.getGame().getCurrentDefaultCivilization(iLoopHero)).getButton(), iLeft + iOffSet, 0, 48, 48, WidgetTypes.WIDGET_PEDIA_JUMP_TO_CIV, gc.getGame().getCurrentDefaultCivilization(iLoopHero), -1)
                iOffSet += 80

		# Default Civilization Loyalty
		itemName = self.getNextWidgetName()
		if gc.getGame().getCurrentDefaultCivilization(iLoopHero) != -1:
			iCivLoyalty = objHero.getCivilizationLoyalty(gc.getGame().getCurrentDefaultCivilization(iLoopHero))
			szCivLoyalty = " %d" % (iCivLoyalty)
			if iCivLoyalty == 100:
				szCivLoyalty = localText.changeTextColor(szCivLoyalty, gc.getInfoTypeForString("COLOR_RED"))
		else:
			szCivLoyalty = ""
		screen.setTextAt(itemName, infoPanelName, szCivLoyalty, CvUtil.FONT_CENTER_JUSTIFY, iLeft + iOffSet, iInsideGap, -0.1, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)
                iOffSet += 80

                # Leadership
                itemName = self.getNextWidgetName()
                szLeadership = "%d" % (objHero.getLeadership())
                screen.setTextAt(itemName, infoPanelName, szLeadership, CvUtil.FONT_CENTER_JUSTIFY, iLeft + iOffSet, iInsideGap, -0.1, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)
                iOffSet += 80

                # Might
                itemName = self.getNextWidgetName()
                szMight = "%d" % (objHero.getMight())
                screen.setTextAt(itemName, infoPanelName, szMight, CvUtil.FONT_CENTER_JUSTIFY, iLeft + iOffSet, iInsideGap, -0.1, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)
                iOffSet += 80

		# Gold Required
		itemName = self.getNextWidgetName()
		if (gc.getPlayer(self.iActiveLeader).canEverRecruitHero(iLoopHero)):
			iGold = gc.getPlayer(self.iActiveLeader).getRecruitHeroGold(iLoopHero)
			szGoldRequired = u"%c" % (gc.getCommerceInfo(0).getChar())

			szColor = "COLOR_YELLOW"
			szGoldRequired = localText.changeTextColor(szGoldRequired + " %d" % (iGold), gc.getInfoTypeForString(szColor))
			szGoldRequired = "<font=2>" + szGoldRequired + "</font>"
		else:
			szGoldRequired = ""

		if CyGame().getCurrentLanguage() == 5:
			screen.setTextAt(itemName, infoPanelName, szGoldRequired, CvUtil.FONT_CENTER_JUSTIFY, iLeft + iOffSet, iInsideGap, -0.1, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)
		else:
			screen.setTextAt(itemName, infoPanelName, szGoldRequired, CvUtil.FONT_CENTER_JUSTIFY, iLeft + iOffSet, iInsideGap, -0.1, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)
                iOffSet += 80 * 2

		# Recruit Button
		if gc.getPlayer(self.iActiveLeader).canRecruitHero(iLoopHero, False):
			szAction = BugUtil.getPlainText("TXT_KEY_HERO_ADVISOR_RECRUIT")
			#screen.setButtonGFC( "Recruit", szAction, "", iLeft + 100 + iInsideGap * 6 + iOffSet * 13 / 2, iRowHeight * iCount + iInsideGap + 100,  76, 30, WidgetTypes.WIDGET_GENERAL, iLoopHero, self.iActiveLeader, ButtonStyles.BUTTON_STYLE_STANDARD )
			#screen.setActivation( "Recruit", ActivationTypes.ACTIVATE_MIMICPARENTFOCUS )
			if CyGame().getCurrentLanguage() == 5:
				screen.setTextAt( "Recruit" + str(iLoopHero), infoPanelName, szAction, CvUtil.FONT_CENTER_JUSTIFY, iLeft + iOffSet, iInsideGap, -0.1, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, iLoopHero, self.iActiveLeader)
			else:
				screen.setTextAt( "Recruit" + str(iLoopHero), infoPanelName, szAction, CvUtil.FONT_LEFT_JUSTIFY, iLeft + iOffSet, iInsideGap, -0.1, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, iLoopHero, self.iActiveLeader)

                iOffSet += 80

		screen.setActivation( "Recruit" + str(iLoopHero), ActivationTypes.ACTIVATE_MIMICPARENTFOCUS )

		screen.show(infoPanelName)


	# draw hero info panel
	def drawInfo(self):
		screen = self.getScreen()

		for sWidget in self.WidgetNames:
			screen.deleteWidget(sWidget)

		# Some spacing variables to help with the layout
		iOutsideGap = 6
		iInsideGap = 10
		iBetweenGap = iOutsideGap - 2
		iHeaderHeight = 48

		# Header
		headerBackgroundPanelName = "HeaderBackground"
		iLeft = iOutsideGap
		iTop = 50 + iOutsideGap
		iWidth = self.W_SCREEN - (2 * iOutsideGap)
		iHeight = iHeaderHeight + (2 * iInsideGap)
		screen.addPanel(headerBackgroundPanelName, "", "", True, False, iLeft, iTop, iWidth, iHeight, PanelStyles.PANEL_STYLE_MAIN)

		headerPanelName = "Header"
		iLeft = iLeft + iInsideGap
		iTop = iTop + iInsideGap
		iWidth = iWidth - (2 * iInsideGap)
		iHeight = iHeaderHeight
		screen.addPanel(headerPanelName, "", "", False, True, iLeft, iTop, iWidth, iHeight, PanelStyles.PANEL_STYLE_EMPTY)

		# set the content of the header
		iX_Content = 65
		iOffset = 40
		iY_Content = 15
		iCount = 0
		iIconSize = 32

		screen.setTextAt( self.getNextWidgetName(), headerPanelName, BugUtil.getPlainText("TXT_KEY_HERO_CURRENT_CIVILIZATION"), CvUtil.FONT_CENTER_JUSTIFY, iX_Content, iY_Content, 0, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)

##                screen.setTextAt( self.getNextWidgetName(), headerPanelName, BugUtil.getPlainText("TXT_KEY_HERO_XP"), CvUtil.FONT_CENTER_JUSTIFY, iX_Content + iOffset * 2, iY_Content, 0, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)

		for sUnitCombat in ["MELEE", "MOUNTED", "ARCHER", "SIEGE", "NAVAL"]:
			screen.setImageButtonAt( self.getNextWidgetName(), headerPanelName, self.UnitCombatInfo[sUnitCombat].getButton(), iX_Content + iOffset * 3 + iIconSize * iCount, iY_Content - 10, iIconSize, iIconSize, WidgetTypes.WIDGET_PEDIA_JUMP_TO_UNIT_COMBAT, self.UnitCombatEnum[sUnitCombat], -1)
			iCount += 1

		screen.setTextAt( self.getNextWidgetName(), headerPanelName, BugUtil.getPlainText("TXT_KEY_HERO_XP"), CvUtil.FONT_CENTER_JUSTIFY, iX_Content + iOffset * 3 + 10 + iIconSize * iCount, iY_Content, 0, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)

		screen.setTextAt( self.getNextWidgetName(), headerPanelName, BugUtil.getPlainText("TXT_KEY_PEDIA_PROMOTION_CLASS"), CvUtil.FONT_CENTER_JUSTIFY, iX_Content + iOffset * 4 + 20 + iIconSize * iCount, iY_Content - 10, 0, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)
		screen.setTextAt( self.getNextWidgetName(), headerPanelName, BugUtil.getPlainText("TXT_KEY_PEDIA_UNIQUE_PROMOTION"), CvUtil.FONT_CENTER_JUSTIFY, iX_Content + iOffset * 4 + 20 + iIconSize * iCount + 5, iY_Content + 10, 0, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)

		screen.setTextAt( self.getNextWidgetName(), headerPanelName, BugUtil.getPlainText("TXT_KEY_PEDIA_PROMOTION_CLASS"), CvUtil.FONT_CENTER_JUSTIFY, iX_Content + iOffset * 8 + 30 + iIconSize * iCount, iY_Content - 10, 0, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)
		screen.setTextAt( self.getNextWidgetName(), headerPanelName, BugUtil.getPlainText("TXT_KEY_PEDIA_MEMBER_PROMOTION"), CvUtil.FONT_CENTER_JUSTIFY, iX_Content + iOffset * 8 + 30 + iIconSize * iCount + 5, iY_Content + 10, 0, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)

		screen.setTextAt( self.getNextWidgetName(), headerPanelName, BugUtil.getPlainText("TXT_KEY_HERO_LEGION_MEMBER"), CvUtil.FONT_CENTER_JUSTIFY, iX_Content + iOffset * 12 + 40 + iIconSize * iCount, iY_Content, 0, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)

		screen.setTextAt( self.getNextWidgetName(), headerPanelName, BugUtil.getPlainText("INTERFACE_PANE_CAPACITY"), CvUtil.FONT_CENTER_JUSTIFY, iX_Content + iOffset * 16 + 45 + iIconSize * iCount, iY_Content - 10, 0, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)
		screen.setTextAt( self.getNextWidgetName(), headerPanelName, BugUtil.getPlainText("INTERFACE_PANE_NEXT_CAPACITY_EXPERIENCE"), CvUtil.FONT_CENTER_JUSTIFY, iX_Content + iOffset * 16 + 45 + iIconSize * iCount, iY_Content + 10, 0, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)

		# Main
		mainBackgroundPanelName = "MainBackground"
		iLeft = iOutsideGap
		iTop = iTop + iHeaderHeight + iInsideGap + iBetweenGap
		iWidth = self.W_SCREEN - (2 * iOutsideGap)
		iHeight = self.H_SCREEN - 100 - (2 * iOutsideGap) - iBetweenGap - iHeaderHeight - (2 * iInsideGap)
		screen.addPanel(mainBackgroundPanelName, "", "", True, False, iLeft, iTop, iWidth, iHeight, PanelStyles.PANEL_STYLE_MAIN)

		mainPanelName = "Main"
		iLeft = iLeft + iInsideGap
		iTop = iTop + iInsideGap
		iWidth = iWidth - (2 * iInsideGap)
		iHeight = iHeight - (4 * iInsideGap)
		screen.addScrollPanel(mainPanelName, "", iLeft, iTop, iWidth, iHeight, PanelStyles.PANEL_STYLE_EXTERNAL)
		screen.setActivation( mainPanelName, ActivationTypes.ACTIVATE_NORMAL )

		# loop through all other heroes and add their rows; show own faction hero first; order by faction, within faction order alphabetically.
		lOurHeroes = {}
		lFactionList = []
		lEmployedHeroes = {}
##>>> HoTK_JP Add for Debug
		lOtherHeroes = {}
##<<< HoTK_JP
		for iLoopHero in range(gc.getNumHeroInfos()):
			if gc.getGame().getHeroDebutStatus(iLoopHero) == gc.getGame().getActivePlayer():
				lOurHeroes[gc.getHeroInfo(iLoopHero).getType()] = iLoopHero
			elif gc.getGame().getHeroDebutStatus(iLoopHero) >= 0:
				if gc.getGame().getHeroDebutStatus(iLoopHero) not in lFactionList:
					lFactionList.append(gc.getGame().getHeroDebutStatus(iLoopHero))
				if gc.getGame().getHeroCapturePlayer(iLoopHero) == gc.getGame().getActivePlayer():
					lEmployedHeroes[gc.getHeroInfo(iLoopHero).getType()] = iLoopHero
				else:
					pLoopHero = gc.getPlayer(gc.getGame().getHeroDebutStatus(iLoopHero)).getUnit(gc.getGame().getHeroUnitID(iLoopHero))
##HoTK_JP fixed START  by yos
					#if pLoopHero:
					if not pLoopHero.isNone():
##HoTK_JP fixed END
						pPlot = pLoopHero.plot()
						if pPlot.isActiveVisible(gc.getGame().isDebugMode()):
							lEmployedHeroes[gc.getHeroInfo(iLoopHero).getType()] = iLoopHero
##>>> HoTK_JP Add for Debug
			elif gc.getGame().isDebugMode():
				lOtherHeroes[gc.getHeroInfo(iLoopHero).getType()] = iLoopHero
##<<< HoTK_JP

		iCount = 0
		lTempList = lOurHeroes.keys()
		lTempList.sort()
		for sType in lTempList:
			self.drawInfoRow(screen, mainPanelName, lOurHeroes[sType], PanelStyles.PANEL_STYLE_STANDARD, gc.getGame().getHeroDebutStatus(lOurHeroes[sType]), iCount)
			iCount += 1
		lTempList = lEmployedHeroes.keys()
		lTempList.sort()
		for iDebutStatus in lFactionList:
			for sType in lTempList:
				if gc.getGame().getHeroDebutStatus(lEmployedHeroes[sType]) == iDebutStatus:
					self.drawInfoRow(screen, mainPanelName, lEmployedHeroes[sType], PanelStyles.PANEL_STYLE_STANDARD, iDebutStatus, iCount)
					iCount += 1
##>>> HoTK_JP Add for Debug
		if gc.getGame().isDebugMode():
			lTempList = lOtherHeroes.keys()
			lTempList.sort()
			for sType in lTempList:
				self.drawInfoRow(screen, mainPanelName, lOtherHeroes[sType], PanelStyles.PANEL_STYLE_STANDARD, gc.getGame().getHeroDebutStatus(lOtherHeroes[sType]), iCount)
				iCount += 1
##<<< HoTK_JP


	# draws the current hero unit's stats
	def drawInfoRow (self, screen, mainPanelName, iLoopHero, ePanelStyle, iDebutStatus, iRowNum):

		objHero = gc.getHeroInfo (iLoopHero)

		iOutsideGap = 6
		iInsideGap = 10
		iBetweenGap = iOutsideGap - 2
		iHeaderHeight = 32

		iLeft = iOutsideGap + iInsideGap
		iTop = 50 + iOutsideGap + iHeaderHeight + iInsideGap * 2 + iBetweenGap
		iWidth = self.W_SCREEN - (4 * iOutsideGap)
		iRowHeight = 48

		iOffSet = 32

		CurrentLevels = {'MELEE'    :    gc.getHeroInfo(iLoopHero).getUnitCombatLevel(self.UnitCombatEnum['MELEE']),
				 'MOUNTED'  :    gc.getHeroInfo(iLoopHero).getUnitCombatLevel(self.UnitCombatEnum['MOUNTED']),
				 'ARCHER'   :    gc.getHeroInfo(iLoopHero).getUnitCombatLevel(self.UnitCombatEnum['ARCHER']),
				 'SIEGE'    :    gc.getHeroInfo(iLoopHero).getUnitCombatLevel(self.UnitCombatEnum['SIEGE']),
				 'NAVAL'    :    gc.getHeroInfo(iLoopHero).getUnitCombatLevel(self.UnitCombatEnum['NAVAL'])}

		PotentialLevels ={'MELEE'    :    gc.getHeroInfo(iLoopHero).getPotentialUnitCombatLevel(self.UnitCombatEnum['MELEE']),
				  'MOUNTED'  :    gc.getHeroInfo(iLoopHero).getPotentialUnitCombatLevel(self.UnitCombatEnum['MOUNTED']),
				  'ARCHER'   :    gc.getHeroInfo(iLoopHero).getPotentialUnitCombatLevel(self.UnitCombatEnum['ARCHER']),
				  'SIEGE'    :    gc.getHeroInfo(iLoopHero).getPotentialUnitCombatLevel(self.UnitCombatEnum['SIEGE']),
				  'NAVAL'    :    gc.getHeroInfo(iLoopHero).getPotentialUnitCombatLevel(self.UnitCombatEnum['NAVAL'])}

		if iDebutStatus >= 0:
			for szUnitCombat in CurrentLevels.keys():
				CurrentLevels[szUnitCombat] = gc.getGame().getHeroUnitCombatLevel(iLoopHero, self.UnitCombatEnum[szUnitCombat])

		# Hero panel
		infoPanelName = self.getNextWidgetName()
		szHeroLable = "" # objLoopPlayer.getName()
		screen.attachPanelAt( mainPanelName, infoPanelName, szHeroLable, "", False, False, ePanelStyle, 0, iRowHeight * iRowNum, iWidth - iOutsideGap * 7, iRowHeight, WidgetTypes.WIDGET_GENERAL, -1, -1 )
		screen.setActivation( infoPanelName, ActivationTypes.ACTIVATE_MIMICPARENTFOCUS)
		screen.hide(infoPanelName)

		itemName = self.getNextWidgetName()

		screen.setImageButtonAt(itemName, infoPanelName, objHero.getButton(), 0, 0, 48, 48, WidgetTypes.WIDGET_PEDIA_JUMP_TO_HERO, iLoopHero, -1)

		# Debut Status
		itemName = self.getNextWidgetName()
		if iDebutStatus == -2:
			szAttStr = "<font=2>" + BugUtil.getPlainText("TXT_KEY_HERO_ADVISOR_AVAILABLE") + "</font>"
			screen.setTextAt(itemName, infoPanelName, szAttStr, CvUtil.FONT_LEFT_JUSTIFY, iLeft + 42, iInsideGap, -0.1, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)
		elif iDebutStatus == -1:
			szAttStr = "<font=2>" + BugUtil.getPlainText("TXT_KEY_HERO_ADVISOR_UNKNOWN") + "</font>"
			screen.setTextAt(itemName, infoPanelName, szAttStr, CvUtil.FONT_LEFT_JUSTIFY, iLeft + 42, iInsideGap, -0.1, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)
		elif iDebutStatus == -3:
			szAttStr = "<font=2>" + BugUtil.getPlainText("TXT_KEY_HERO_ADVISOR_DECEASED") + "</font>"
			screen.setTextAt(itemName, infoPanelName, szAttStr, CvUtil.FONT_LEFT_JUSTIFY, iLeft + 42, iInsideGap, -0.1, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)
		if iDebutStatus >= 0:
			if not self.objActiveTeam.isHasMet(gc.getPlayer(iDebutStatus).getTeam()) and not gc.getGame().isDebugMode():
				screen.setImageButtonAt(itemName, infoPanelName, gc.getDefineSTRING("LEADERHEAD_RANDOM"), iLeft + 42, 0, iRowHeight, iRowHeight, WidgetTypes.WIDGET_GENERAL, -1, -1)
			else:
				screen.setImageButtonAt(itemName, infoPanelName, gc.getCivilizationInfo(gc.getPlayer(iDebutStatus).getCivilizationType()).getButton(), iLeft + 42, 0, iRowHeight, iRowHeight, WidgetTypes.WIDGET_PEDIA_JUMP_TO_CIV, gc.getPlayer(iDebutStatus).getCivilizationType(), -1)
##>>> HoTK_JP Add for Debug
		if gc.getGame().isDebugMode():
			itemName = self.getNextWidgetName()
			screen.setTextAt(itemName, infoPanelName, str(iDebutStatus), CvUtil.FONT_LEFT_JUSTIFY, iLeft + 42 + 100 + iInsideGap, iInsideGap - 10, -0.1, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)
			itemName = self.getNextWidgetName()
			screen.setTextAt(itemName, infoPanelName, str(iLoopHero), CvUtil.FONT_LEFT_JUSTIFY, iLeft + 42 + 100 + iInsideGap, iInsideGap + 10, -0.1, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)
##<<< HoTK_JP

		# Experience
##                itemName = self.getNextWidgetName()
##                szXP = "%d" % (gc.getGame().getHeroExperience(iLoopHero))
##                if iDebutStatus >= 0:
##                        szXP += "/" + "%d" % (gc.getGame().heroExperienceNeeded(iLoopHero))
##
##                screen.setTextAt(itemName, infoPanelName, szXP, CvUtil.FONT_LEFT_JUSTIFY, iLeft + 42 + iInsideGap * 2 + iOffSet * 2, iInsideGap, -0.1, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)

		# Unit Combat Level
		if iRowNum == 0 and gc.getGame().getHeroCapturePlayer(iLoopHero) == -1:
			itemName = self.getNextWidgetName()
			screen.setTextAt(itemName, infoPanelName, BugUtil.getPlainText("TXT_KEY_PEDIA_HERO_CURRENT"), CvUtil.FONT_LEFT_JUSTIFY, iLeft + 42 + iRowHeight + iInsideGap, iInsideGap - 10, -0.1, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)

			itemName = self.getNextWidgetName()
			screen.setTextAt(itemName, infoPanelName, BugUtil.getPlainText("TXT_KEY_PEDIA_HERO_POTENTIAL_NO_BULLET"), CvUtil.FONT_LEFT_JUSTIFY, iLeft + 42 + iRowHeight + iInsideGap, iInsideGap + 10, -0.1, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)
		elif gc.getGame().getHeroCapturePlayer(iLoopHero) != -1:
			itemName = self.getNextWidgetName()
			screen.setTextAt(itemName, infoPanelName, BugUtil.getPlainText("TXT_KEY_PEDIA_HERO_IMPRISONED"), CvUtil.FONT_LEFT_JUSTIFY, iLeft + 42 + iRowHeight + iInsideGap, iInsideGap, -0.1, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)

		iCount = 0
		for szUnitCombat in ["MELEE", "MOUNTED", "ARCHER", "SIEGE", "NAVAL"]:
			itemName = self.getNextWidgetName()
			screen.setTextAt(itemName, infoPanelName, self.CombatLevelSign[ CurrentLevels[szUnitCombat] ], CvUtil.FONT_LEFT_JUSTIFY, iLeft + 42 + iRowHeight + iInsideGap * 2 + iOffSet * (2 + iCount), iInsideGap - 10, -0.1, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)
			itemName = self.getNextWidgetName()
			if gc.getHeroInfo(iLoopHero).isRandom() and CurrentLevels[szUnitCombat] < PotentialLevels[szUnitCombat]:
				screen.setTextAt(itemName, infoPanelName, '?', CvUtil.FONT_LEFT_JUSTIFY, iLeft + 42 + iRowHeight + iInsideGap * 2 + iOffSet * (2 + iCount), iInsideGap + 10, -0.1, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)
			else:
				screen.setTextAt(itemName, infoPanelName, self.CombatLevelSign[ PotentialLevels[szUnitCombat] ], CvUtil.FONT_LEFT_JUSTIFY, iLeft + 42 + iRowHeight + iInsideGap * 2 + iOffSet * (2 + iCount), iInsideGap + 10, -0.1, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)
			iCount += 1

		# XP
		itemName = self.getNextWidgetName()
		szXPCurrent = str(int(gc.getGame().getHeroExperience(iLoopHero)))
		if iDebutStatus >= 0:
			szXPNeeded = str(gc.getGame().heroExperienceNeeded(iLoopHero))

		screen.setTextAt(itemName, infoPanelName, szXPCurrent, CvUtil.FONT_LEFT_JUSTIFY, iLeft + 37 + iRowHeight + iInsideGap * 2 + iOffSet * (2 + iCount), iInsideGap - 10, -0.1, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)
		itemName = self.getNextWidgetName()
		if iDebutStatus >= 0:
			screen.setTextAt(itemName, infoPanelName, szXPNeeded, CvUtil.FONT_LEFT_JUSTIFY, iLeft + 37 + iRowHeight + iInsideGap * 2 + iOffSet * (2 + iCount), iInsideGap + 10, -0.1, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)

		# Promotions
		UniquePromotions = self.getNextWidgetName()
		MemberPromotions = self.getNextWidgetName()
		screen.addMultiListControlGFCAt( infoPanelName, UniquePromotions, "Unique Promotions", iLeft + 42 + iRowHeight + iInsideGap * 4 + iOffSet * (2 + iCount), 0, iRowHeight * 7 / 2, iRowHeight, 1, iRowHeight, iRowHeight, TableStyles.TABLE_STYLE_STANDARD )
		screen.hide( UniquePromotions )
		screen.addMultiListControlGFCAt( infoPanelName, MemberPromotions, "Member Promotions", iLeft + 42 + iRowHeight * 9 / 2 + iInsideGap * 5 + iOffSet * (2 + iCount), 0, iRowHeight * 7 / 2, iRowHeight, 1, iRowHeight, iRowHeight, TableStyles.TABLE_STYLE_STANDARD )
		screen.hide( MemberPromotions )

		for j in range (gc.getNumPromotionInfos()):
			if ( gc.getGame().getHeroPromotionStatus(iLoopHero, j) == 1 ):
				szButton = gc.getPromotionInfo(j).getButton()
				screen.appendMultiListButton( UniquePromotions, szButton, 0, WidgetTypes.WIDGET_PEDIA_JUMP_TO_PROMOTION, j, -1, False )
				screen.show( UniquePromotions )
			elif ( gc.getGame().getHeroPromotionStatus(iLoopHero, j) == 2 ):
				szButton = gc.getPromotionInfo(j).getButton()
				screen.appendMultiListButton( MemberPromotions, szButton, 0, WidgetTypes.WIDGET_PEDIA_JUMP_TO_PROMOTION, j, -1, False )
				screen.show( MemberPromotions )

		# LegionMembers
		LegionMembers = self.getNextWidgetName()
		screen.addMultiListControlGFCAt( infoPanelName, LegionMembers, "Legion Members", iLeft + 42 + iRowHeight * 8 + iInsideGap * 6 + iOffSet * (2 + iCount), 0, iRowHeight * 7 / 2, iRowHeight, 1, iRowHeight, iRowHeight, TableStyles.TABLE_STYLE_STANDARD )
		screen.hide( LegionMembers )

		if iDebutStatus >= 0:
			for iIndex in range (gc.getGame().getHeroLegionSize(iLoopHero)):
				pMember = gc.getPlayer(iDebutStatus).getUnit(gc.getGame().getHeroLegionMemberAt(iLoopHero, iIndex))
				if pMember.getLeaderHero() == iLoopHero:
					szButton = gc.getHeroInfo(pMember.getHeroType()).getButton()
					widget = WidgetTypes.WIDGET_PEDIA_JUMP_TO_HERO
					iData1 = pMember.getHeroType()
				else:
					szButton = pMember.getButton()
					widget = WidgetTypes.WIDGET_PEDIA_JUMP_TO_UNIT
					iData1 = pMember.getUnitType()
				screen.appendMultiListButton( LegionMembers, szButton, 0, widget, iData1, -1, False )
				screen.show( LegionMembers )

		# Capacity
		itemName = self.getNextWidgetName()
		szCapacity = str(gc.getGame().getHeroCapacity(iLoopHero, False, -1))
		szXPNeeded = str(gc.getGame().getHeroExperienceNeededForNextCapacity(iLoopHero))

		screen.setTextAt(itemName, infoPanelName, szCapacity, CvUtil.FONT_LEFT_JUSTIFY, iLeft + 42 + iRowHeight * 23 / 2 + iInsideGap * 7 + iOffSet * (2 + iCount), iInsideGap - 10, -0.1, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)
		itemName = self.getNextWidgetName()
		screen.setTextAt(itemName, infoPanelName, szXPNeeded, CvUtil.FONT_LEFT_JUSTIFY, iLeft + 42 + iRowHeight * 23 / 2 + iInsideGap * 7 + iOffSet * (2 + iCount), iInsideGap + 10, -0.1, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)


		screen.show(infoPanelName)


	def drawPrisoner(self):

		screen = self.getScreen()

		# Some spacing variables to help with the layout
		screen.deleteWidget("MainBackground")
		screen.deleteWidget("Main")
		szPanel = "HeroPanel"

		# Some spacing variables to help with the layout
		iOutsideGap = 6
		iInsideGap = 10
		iBetweenGap = iOutsideGap - 2
		iHeaderHeight = 32

		# Header
		headerBackgroundPanelName = "HeaderBackground"
		iLeft = iOutsideGap
		iTop = 50 + iOutsideGap
		iWidth = self.W_SCREEN - (2 * iOutsideGap)
		iHeight = iHeaderHeight + (2 * iInsideGap)
		screen.addPanel(headerBackgroundPanelName, "", "", True, False, iLeft, iTop, iWidth, iHeight, PanelStyles.PANEL_STYLE_MAIN)

		headerPanelName = "Header"
		iLeft = iLeft + iInsideGap
		iTop = iTop + iInsideGap
		iWidth = iWidth - (2 * iInsideGap)
		iHeight = iHeaderHeight
		screen.addPanel(headerPanelName, "", "", False, True, iLeft, iTop, iWidth, iHeight, PanelStyles.PANEL_STYLE_EMPTY)

		screen.addScrollPanel( szPanel, u"", self.X_HERO_PANE, self.Y_HERO_PANE, self.W_HERO_PANE, self.H_HERO_PANE - 20, PanelStyles.PANEL_STYLE_EXTERNAL )
		screen.setActivation( szPanel, ActivationTypes.ACTIVATE_NORMAL )

		iCount = 0
		iButtonSize = 48
		iIncrement = 1
		self.PrisonerHeroes = []
		for iHero in range(gc.getNumHeroInfos()):
			if gc.getGame().getHeroCapturePlayer(iHero) == self.iActiveLeader:
				self.PrisonerHeroes.append(iHero)
				infoPanelName = "HeroRow" + str(iHero)
				screen.attachPanelAt( szPanel, infoPanelName, "", "", False, False, PanelStyles.PANEL_STYLE_STANDARD, iIncrement, iButtonSize * iCount + iIncrement * (iCount + 1), self.W_HERO_PANE - 35, iButtonSize + iIncrement * 2, WidgetTypes.WIDGET_GENERAL, -1, -1 )
				screen.setActivation( infoPanelName, ActivationTypes.ACTIVATE_MIMICPARENTFOCUS)
				screen.hide(infoPanelName)

				itemName = "HeroButton" + str(iHero)
				screen.addCheckBoxGFCAt( infoPanelName, itemName, gc.getHeroInfo(iHero).getButton(), ArtFileMgr.getInterfaceArtInfo("BUTTON_HILITE_SQUARE").getPath(), iIncrement, iIncrement, iButtonSize, iButtonSize, WidgetTypes.WIDGET_GENERAL, iHero, -1, ButtonStyles.BUTTON_STYLE_LABEL, False )

				if iCount == 0:
					self.iHero = iHero
					screen.setState("HeroButton" + str(iHero), True)
					self.drawPediaContent(iHero)
					self.updateHandleButtons(iHero, iLeft, iInsideGap, iTop)

				iCount += 1

				screen.show(infoPanelName)

	def updatePrisoners(self, iHero):
		self.PrisonerHeroes.remove(iHero)
		screen = self.getScreen()
		screen.deleteWidget("HeroRow" + str(iHero))
		screen.deleteWidget("HeroButton" + str(iHero))

		if len(self.PrisonerHeroes) > 0:
			self.iHero = self.PrisonerHeroes[0]
			screen.setState("HeroButton" + str(self.iHero), True)
			self.drawPediaContent(self.iHero)
			self.updateHandleButtons(self.iHero, 16, 10, 66)
		else:
			screen.hideScreen()

	def drawPediaContent(self, iHero):
		screen = self.getScreen()

		screen.addPanel("PortraitPanel", "", "", False, False, self.X_UNIT_PANE, self.Y_UNIT_PANE, self.W_UNIT_PANE, self.H_UNIT_PANE, PanelStyles.PANEL_STYLE_BLUE50)
		screen.addDDSGFC("Portrait", gc.getHeroInfo(iHero).getPortrait(), self.X_ICON, self.Y_ICON, self.W_ICON, self.H_ICON, WidgetTypes.WIDGET_GENERAL, -1, -1)
		#screen.addUnitGraphicGFC("UnitGraphic", gc.getHeroInfo(iHero).getUnitType(), self.X_UNIT_ANIMATION, self.Y_UNIT_ANIMATION, self.W_UNIT_ANIMATION, self.H_UNIT_ANIMATION, WidgetTypes.WIDGET_GENERAL, -1, -1, self.X_ROTATION_UNIT_ANIMATION, self.Z_ROTATION_UNIT_ANIMATION, self.SCALE_ANIMATION, True)

		panelName = "Stats"
		screen.addPanel(panelName, localText.getText("TXT_KEY_PEDIA_HERO_STATS", ()), "", False, True, self.X_UNIT_ANIMATION, self.Y_UNITCOMBAT_PANE, self.W_UNIT_ANIMATION, self.H_UNITCOMBAT_PANE, PanelStyles.PANEL_STYLE_BLUE50)
		screen.attachLabel(panelName, "", "  ")

		screen.setTextAt("Name", panelName, gc.getHeroInfo(iHero).getDescription(), CvUtil.FONT_CENTER_JUSTIFY, 5, 0, 0, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)
		screen.setTextAt("Leadership", panelName, localText.getText("TXT_KEY_RECRUIT_HERO_LEADERSHIP", (gc.getHeroInfo(iHero).getLeadership(), )), CvUtil.FONT_CENTER_JUSTIFY, 5, 18, 0, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)
		screen.setTextAt("Might", panelName, localText.getText("TXT_KEY_RECRUIT_HERO_MIGHT", (gc.getHeroInfo(iHero).getMight(), )), CvUtil.FONT_CENTER_JUSTIFY, 5, 36, 0, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)
		screen.setTextAt("XP", panelName, localText.getText("TXT_KEY_RECRUIT_HERO_EXPERIENCE", (int(gc.getGame().getHeroExperience(iHero)), )), CvUtil.FONT_CENTER_JUSTIFY, 5, 54, 0, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)

		self.placeCivAndBelief(iHero)
		self.placeUnitCombatLevel(iHero)
		self.placeSpecial(iHero)
		self.placePromotions(iHero)
		self.placeHistory(iHero)

	def updateHandleButtons(self, iHero, iLeft, iInsideGap, iTop):
		screen = self.getScreen()

		if gc.getGame().willHeroJoinFaction(iHero, self.iActiveLeader):
			screen.setButtonGFC( "Persuade", localText.getText("TXT_KEY_SCREEN_PERSUADE", ()), "", iLeft + iInsideGap, iTop + 2,  76, 30, self.PersuadeWidget, -1, -1, ButtonStyles.BUTTON_STYLE_STANDARD )
			screen.setActivation( "Persuade", ActivationTypes.ACTIVATE_MIMICPARENTFOCUS )
		else:
			screen.deleteWidget( "Persuade" )

		if gc.getGame().isOption(gc.getInfoTypeForString("GAMEOPTION_NO_HERO_EXECUTION")) == False:
                        screen.setButtonGFC( "Execute", localText.getText("TXT_KEY_SCREEN_EXECUTE", ()), "", iLeft + 76 + iInsideGap * 2, iTop + 2,  76, 30, self.ExecuteWidget, -1, -1, ButtonStyles.BUTTON_STYLE_STANDARD )
                        screen.setActivation( "Execute", ActivationTypes.ACTIVATE_MIMICPARENTFOCUS )
		screen.setButtonGFC( "Release", localText.getText("TXT_KEY_SCREEN_RELEASE", ()), "", iLeft + 76 * 2 + iInsideGap * 3, iTop + 2,  76, 30, self.ReleaseWidget, -1, -1, ButtonStyles.BUTTON_STYLE_STANDARD )
		screen.setActivation( "Release", ActivationTypes.ACTIVATE_MIMICPARENTFOCUS )

		iPlayer = gc.getGame().getHeroDebutStatus(iHero)
		if gc.getPlayer(self.iActiveLeader).canContact(iPlayer):
			screen.setButtonGFC( "Trade", localText.getText("TXT_KEY_SCREEN_TRADE", ()), "", iLeft + 76 * 3 + iInsideGap * 4, iTop + 2, 76, 30, WidgetTypes.WIDGET_CONTACT_CIV, iPlayer, -1, ButtonStyles.BUTTON_STYLE_STANDARD )
			screen.setActivation( "Trade", ActivationTypes.ACTIVATE_MIMICPARENTFOCUS )
		else:
                        screen.deleteWidget( "Trade" )

		szText = ""
		iPlayer = gc.getGame().getHeroDebutStatus(iHero)
		if iPlayer >= 0 and gc.getPlayer(iPlayer).isAlive():
			WidgetUtil.setWidgetHelpText(self.PersuadeWidget, localText.getText("TXT_KEY_PERSUADE_HELP_PLAYER", (gc.getHeroInfo(iHero).getDescription(), gc.getPlayer(iPlayer).getCivilizationDescription(0))))
			WidgetUtil.setWidgetHelpText(self.ExecuteWidget, localText.getText("TXT_KEY_EXECUTE_HELP_PLAYER", (gc.getHeroInfo(iHero).getDescription(), gc.getPlayer(iPlayer).getCivilizationDescription(0))))
			WidgetUtil.setWidgetHelpText(self.ReleaseWidget, localText.getText("TXT_KEY_RELEASE_HELP_PLAYER", (gc.getHeroInfo(iHero).getDescription(), gc.getPlayer(iPlayer).getCivilizationDescription(0))))
		else:
			WidgetUtil.setWidgetHelpText(self.PersuadeWidget, localText.getText("TXT_KEY_PERSUADE_HELP", (gc.getHeroInfo(iHero).getDescription(),)))
			WidgetUtil.setWidgetHelpText(self.ExecuteWidget, localText.getText("TXT_KEY_EXECUTE_HELP", (gc.getHeroInfo(iHero).getDescription(),)))
			WidgetUtil.setWidgetHelpText(self.ReleaseWidget, localText.getText("TXT_KEY_RELEASE_HELP", (gc.getHeroInfo(iHero).getDescription(),)))


	def updateHelpText(self, iData2):
		screen = self.getScreen()

		szText = ""
		iPlayer = gc.getGame().getHeroDebutStatus(self.iHero)
		if iData2 == 10001:
			if iPlayer >= 0 and gc.getPlayer(iPlayer).isAlive():
				szText = localText.getText("TXT_KEY_PERSUADE_HELP_PLAYER", (gc.getHeroInfo(self.iHero).getDescription(), gc.getPlayer(iPlayer).getCivilizationDescription(0)))
			else:
				szText = localText.getText("TXT_KEY_PERSUADE_HELP", (gc.getHeroInfo(self.iHero).getDescription(),))
		elif iData2 == 10002:
			if iPlayer >= 0 and gc.getPlayer(iPlayer).isAlive():
				szText = localText.getText("TXT_KEY_EXECUTE_HELP_PLAYER", (gc.getHeroInfo(self.iHero).getDescription(), gc.getPlayer(iPlayer).getCivilizationDescription(0)))
			else:
				szText = localText.getText("TXT_KEY_EXECUTE_HELP", (gc.getHeroInfo(self.iHero).getDescription(),))
		elif iData2 == 10003:
			if iPlayer >= 0 and gc.getPlayer(iPlayer).isAlive():
				szText = localText.getText("TXT_KEY_RELEASE_HELP_PLAYER", (gc.getHeroInfo(self.iHero).getDescription(), gc.getPlayer(iPlayer).getCivilizationDescription(0)))
			else:
				szText = localText.getText("TXT_KEY_RELEASE_HELP", (gc.getHeroInfo(self.iHero).getDescription(),))
		elif iData2 == 10004:
			if iPlayer >= 0 and gc.getPlayer(iPlayer).isAlive():
				szText = localText.getText("TXT_KEY_TRADE_HELP_PLAYER", (gc.getPlayer(iPlayer).getCivilizationDescription(0), gc.getHeroInfo(self.iHero).getDescription()))

		CyInterface().addImmediateMessage(str(iData2), '')
		screen.setTextAt( "Help", "Header", szText, CvUtil.FONT_LEFT_JUSTIFY, 76 * 4 + iInsideGap * 5, 10, 0, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)

	def placeCivAndBelief(self, iHero):
		screen = self.getScreen()

		# Historical Civilizations
		panelName = "CivPanel"
		screen.addPanel(panelName, localText.getText("TXT_KEY_PEDIA_DEFAULT_CIVILIZATION", ()), "", False, True, self.X_CIV_PANE, self.Y_CIV_PANE, self.W_CIV_PANE, self.H_CIV_PANE, PanelStyles.PANEL_STYLE_BLUE50)
		screen.attachLabel(panelName, "", "  ")

		HistoricalCivs = {}
		for i in range (gc.getNumCivilizationInfos()):
			if gc.getHeroInfo(iHero).getDefaultCivilizationEndYear(i) > 0:
				HistoricalCivs[gc.getHeroInfo(iHero).getDefaultCivilizationEndYear(i)] = i

		TempList = HistoricalCivs.keys()
		TempList.sort()

		iCount = 0
		iIncrement = 9
		iButtonSize = 64
		for iValue in TempList:
			screen.setImageButtonAt("CivButton" + str(HistoricalCivs[iValue]), panelName, gc.getCivilizationInfo(HistoricalCivs[iValue]).getButton(), iIncrement * (iCount + 1) + iButtonSize * iCount, 5, iButtonSize, iButtonSize, WidgetTypes.WIDGET_PEDIA_JUMP_TO_CIV, HistoricalCivs[iValue], 1)
			iXIncrement = 2
			if iCount > 0:
				szText = str(gc.getHeroInfo(iHero).getCivilizationLoyalty(HistoricalCivs[iValue]))
				iXIncrement = 30
			else:
				szText = localText.getText("TXT_KEY_PEDIA_HERO_CIV_LOYALTY", (gc.getHeroInfo(iHero).getCivilizationLoyalty(HistoricalCivs[iValue]), ))
			screen.setTextAt("CivLoyalty" + str(HistoricalCivs[iValue]), panelName, szText, CvUtil.FONT_CENTER_JUSTIFY, iIncrement * iCount + iButtonSize * iCount + iXIncrement, iButtonSize + 5, 0, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)
			iCount += 1

		# Belief
		panelName = "BeliefPanel"
		screen.addPanel(panelName, localText.getText("TXT_KEY_PEDIA_HERO_BELIEF", ()), "", False, True, self.X_BELIEF_PANE, self.Y_BELIEF_PANE, self.W_BELIEF_PANE, self.H_BELIEF_PANE, PanelStyles.PANEL_STYLE_BLUE50)
		screen.attachLabel(panelName, "", "  ")

		iBelief = gc.getHeroInfo(iHero).getBelief()
		if iBelief != -1:
			screen.setImageButtonAt("BeliefButton", panelName, gc.getReligionInfo(iBelief).getButton(), (self.W_BELIEF_PANE - iButtonSize) / 2, 5, iButtonSize, iButtonSize, WidgetTypes.WIDGET_PEDIA_JUMP_TO_RELIGION, iBelief, -1)
			szText = localText.getText("TXT_KEY_PEDIA_HERO_BELIEF_STRENGTH", (gc.getHeroInfo(iHero).getBeliefStrength(), ))
			screen.setTextAt("BeliefStrength", panelName, szText, CvUtil.FONT_CENTER_JUSTIFY, 2, iButtonSize  + 5, 0, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)


	def placeUnitCombatLevel(self, iHero):
		screen = self.getScreen()
		panelName = "UnitCombatLevel"
		screen.addPanel(panelName, localText.getText("TXT_KEY_PEDIA_HERO_UNITCOMBAT_LEVEL", ()), "", False, True, self.X_UNITCOMBAT_PANE, self.Y_UNITCOMBAT_PANE, self.W_UNITCOMBAT_PANE, self.H_UNITCOMBAT_PANE, PanelStyles.PANEL_STYLE_BLUE50)
		screen.attachLabel(panelName, "", "  ")

##		iY_Text = 62
##		if CyGame().getCurrentLanguage() == 5:
##			iY_Text = 55
##		screen.setText("Current", "", localText.getText("TXT_KEY_PEDIA_HERO_CURRENT_BULLET", ()), CvUtil.FONT_LEFT_JUSTIFY, self.X_UNITCOMBAT_PANE + 5, self.Y_UNITCOMBAT_PANE + iY_Text, 0, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)
##		screen.setText("Potential", "", localText.getText("TXT_KEY_PEDIA_HERO_POTENTIAL", ()), CvUtil.FONT_LEFT_JUSTIFY, self.X_UNITCOMBAT_PANE + 5, self.Y_UNITCOMBAT_PANE + iY_Text + 20, 0, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)

		UnitCombatEnum = self.UnitCombatEnum

		UnitCombatInfo = self.UnitCombatInfo

		CombatLevelSign = self.CombatLevelSign

		currentLevels = {'MELEE'    :    gc.getGame().getHeroUnitCombatLevel(iHero, UnitCombatEnum['MELEE']),
				  'MOUNTED'  :    gc.getGame().getHeroUnitCombatLevel(iHero, UnitCombatEnum['MOUNTED']),
				  'ARCHER'   :    gc.getGame().getHeroUnitCombatLevel(iHero, UnitCombatEnum['ARCHER']),
				  'SIEGE'    :    gc.getGame().getHeroUnitCombatLevel(iHero, UnitCombatEnum['SIEGE']),
				  'NAVAL'    :    gc.getGame().getHeroUnitCombatLevel(iHero, UnitCombatEnum['NAVAL'])}

		potentialLevels ={'MELEE'    :    gc.getHeroInfo(iHero).getPotentialUnitCombatLevel(UnitCombatEnum['MELEE']),
				  'MOUNTED'  :    gc.getHeroInfo(iHero).getPotentialUnitCombatLevel(UnitCombatEnum['MOUNTED']),
				  'ARCHER'   :    gc.getHeroInfo(iHero).getPotentialUnitCombatLevel(UnitCombatEnum['ARCHER']),
				  'SIEGE'    :    gc.getHeroInfo(iHero).getPotentialUnitCombatLevel(UnitCombatEnum['SIEGE']),
				  'NAVAL'    :    gc.getHeroInfo(iHero).getPotentialUnitCombatLevel(UnitCombatEnum['NAVAL'])}

		iX = 15
		iY = 5
		iIncrement = 4
		iTextSize = 20
		iIconSize = 32

		screen.setImageButtonAt( "MeleeButton", panelName, UnitCombatInfo['MELEE'].getButton(), iX, iY, iIconSize, iIconSize, WidgetTypes.WIDGET_PEDIA_JUMP_TO_UNIT_COMBAT, UnitCombatEnum['MELEE'], -1)
		screen.setTextAt( "MeleeLevel1", panelName, CombatLevelSign[ currentLevels['MELEE'] ], CvUtil.FONT_CENTER_JUSTIFY, iX + 8, iY + iIconSize, 0, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)
		if gc.getHeroInfo(iHero).isRandom() and currentLevels['MELEE'] < potentialLevels['MELEE']:
			screen.setTextAt( "MeleeLevel2", panelName, '?', CvUtil.FONT_CENTER_JUSTIFY, iX + 8, iY + iIconSize + iTextSize, 0, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)
		else:
			screen.setTextAt( "MeleeLevel2", panelName, CombatLevelSign[ potentialLevels.get('MELEE') ], CvUtil.FONT_CENTER_JUSTIFY, iX + 8, iY + iIconSize + iTextSize, 0, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)

		screen.setImageButtonAt( "MountedButton", panelName, UnitCombatInfo['MOUNTED'].getButton(), iX + iIncrement + iIconSize, iY, iIconSize, iIconSize, WidgetTypes.WIDGET_PEDIA_JUMP_TO_UNIT_COMBAT, UnitCombatEnum['MOUNTED'], -1)
		screen.setTextAt( "MountedLevel1", panelName, CombatLevelSign[ currentLevels['MOUNTED'] ], CvUtil.FONT_CENTER_JUSTIFY, iX + iIncrement + iIconSize + 8, iY + iIconSize, 0, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)
		if gc.getHeroInfo(iHero).isRandom() and currentLevels['MOUNTED'] < potentialLevels['MOUNTED']:
			screen.setTextAt( "MountedLevel2", panelName, '?', CvUtil.FONT_CENTER_JUSTIFY, iX + iIncrement + iIconSize + 8, iY + iIconSize + iTextSize, 0, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)
		else:
			screen.setTextAt( "MountedLevel2", panelName, CombatLevelSign[ potentialLevels.get('MOUNTED') ], CvUtil.FONT_CENTER_JUSTIFY, iX + iIncrement + iIconSize + 8, iY + iIconSize + iTextSize, 0, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)

		screen.setImageButtonAt( "ArcherButton", panelName, UnitCombatInfo['ARCHER'].getButton(), iX + iIncrement * 2 + iIconSize * 2, iY, iIconSize, iIconSize, WidgetTypes.WIDGET_PEDIA_JUMP_TO_UNIT_COMBAT, UnitCombatEnum['ARCHER'], -1)
		screen.setTextAt( "ArcherLevel1", panelName, CombatLevelSign[ currentLevels['ARCHER'] ], CvUtil.FONT_CENTER_JUSTIFY, iX + iIncrement * 2 + iIconSize * 2 + 8, iY + iIconSize, 0, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)
		if gc.getHeroInfo(iHero).isRandom() and currentLevels['ARCHER'] < potentialLevels['ARCHER']:
			screen.setTextAt( "ArcherLevel2", panelName, '?', CvUtil.FONT_CENTER_JUSTIFY, iX + iIncrement * 2 + iIconSize * 2 + 8, iY + iIconSize + iTextSize, 0, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)
		else:
			screen.setTextAt( "ArcherLevel2", panelName, CombatLevelSign[ potentialLevels.get('ARCHER') ], CvUtil.FONT_CENTER_JUSTIFY, iX + iIncrement * 2 + iIconSize * 2 + 8, iY + iIconSize + iTextSize, 0, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)

		screen.setImageButtonAt( "SiegeButton", panelName, UnitCombatInfo['SIEGE'].getButton(), iX + iIncrement * 3 + iIconSize * 3, iY, iIconSize, iIconSize, WidgetTypes.WIDGET_PEDIA_JUMP_TO_UNIT_COMBAT, UnitCombatEnum['SIEGE'], -1)
		screen.setTextAt( "SiegeLevel1", panelName, CombatLevelSign[ currentLevels['SIEGE'] ], CvUtil.FONT_CENTER_JUSTIFY, iX + iIncrement * 3 + iIconSize * 3 + 8, iY + iIconSize, 0, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)
		if gc.getHeroInfo(iHero).isRandom() and currentLevels['SIEGE'] < potentialLevels['SIEGE']:
			screen.setTextAt( "SiegeLevel2", panelName, '?', CvUtil.FONT_CENTER_JUSTIFY, iX + iIncrement * 3 + iIconSize * 3 + 8, iY + iIconSize + iTextSize, 0, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)
		else:
			screen.setTextAt( "SiegeLevel2", panelName, CombatLevelSign[ potentialLevels.get('SIEGE') ], CvUtil.FONT_CENTER_JUSTIFY, iX + iIncrement * 3 + iIconSize * 3 + 8, iY + iIconSize + iTextSize, 0, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)

		screen.setImageButtonAt( "NavalButton", panelName, UnitCombatInfo['NAVAL'].getButton(), iX + iIncrement * 4 + iIconSize * 4, iY, iIconSize, iIconSize, WidgetTypes.WIDGET_PEDIA_JUMP_TO_UNIT_COMBAT, UnitCombatEnum['NAVAL'], -1)
		screen.setTextAt( "NavalLevel1", panelName, CombatLevelSign[ currentLevels['NAVAL'] ], CvUtil.FONT_CENTER_JUSTIFY, iX + iIncrement * 4 + iIconSize * 4 + 8, iY + iIconSize, 0, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)
		if gc.getHeroInfo(iHero).isRandom() and currentLevels['NAVAL'] < potentialLevels['NAVAL']:
			screen.setTextAt( "NavalLevel2", panelName, '?', CvUtil.FONT_CENTER_JUSTIFY, iX + iIncrement * 4 + iIconSize * 4 + 8, iY + iIconSize + iTextSize, 0, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)
		else:
			screen.setTextAt( "NavalLevel2", panelName, CombatLevelSign[ potentialLevels.get('NAVAL') ], CvUtil.FONT_CENTER_JUSTIFY, iX + iIncrement * 4 + iIconSize * 4 + 8, iY + iIconSize + iTextSize, 0, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)

	def placeSpecial(self, iHero):
		screen = self.getScreen()
		panelName = "HelpPanel"
		screen.addPanel(panelName, localText.getText("TXT_KEY_PEDIA_SPECIAL_ABILITIES", ()), "", True, False, self.X_SPECIAL_PANE, self.Y_SPECIAL_PANE, self.W_SPECIAL_PANE, self.H_SPECIAL_PANE, PanelStyles.PANEL_STYLE_BLUE50)
		listName = "HelpText"
		szSpecialText = CyGameTextMgr().getUnitHelp(gc.getNumUnitInfos() + iHero, True, False, False, None)[1:]
		screen.addMultilineText(listName, szSpecialText, self.X_SPECIAL_PANE+5, self.Y_SPECIAL_PANE+30, self.W_SPECIAL_PANE-10, self.H_SPECIAL_PANE-35, WidgetTypes.WIDGET_GENERAL, -1, -1, CvUtil.FONT_LEFT_JUSTIFY)



	def placeHistory(self, iHero):
		screen = self.getScreen()
		panelName = "HistoryPanel"
		screen.addPanel(panelName, localText.getText("TXT_KEY_CIVILOPEDIA_HISTORY", ()), "", True, True, self.X_HISTORY_PANE, self.Y_HISTORY_PANE, self.W_HISTORY_PANE, self.H_HISTORY_PANE, PanelStyles.PANEL_STYLE_BLUE50)
		textName = "HistoryText"
		szText = u""
		if len(gc.getHeroInfo(iHero).getStrategy()) > 0:
			szText += localText.getText("TXT_KEY_CIVILOPEDIA_STRATEGY", ())
			szText += gc.getHeroInfo(iHero).getStrategy()
			szText += u"\n\n"
		szText += localText.getText("TXT_KEY_CIVILOPEDIA_BACKGROUND", ())
		szText += gc.getHeroInfo(iHero).getCivilopedia()
		screen.addMultilineText(textName, szText, self.X_HISTORY_PANE + 15, self.Y_HISTORY_PANE + 40, self.W_HISTORY_PANE - (15 * 2), self.H_HISTORY_PANE - (15 * 2) - 25, WidgetTypes.WIDGET_GENERAL, -1, -1, CvUtil.FONT_LEFT_JUSTIFY)



	def placePromotions(self, iHero):
		screen = self.getScreen()
		panelName = "CurrentPromotionPanel"
		screen.addPanel(panelName, localText.getText("TXT_KEY_PEDIA_CATEGORY_CURRENT_PROMOTION", ()), "", True, True, self.X_CURRENT_PROMO_PANE, self.Y_CURRENT_PROMO_PANE, self.W_CURRENT_PROMO_PANE, self.H_CURRENT_PROMO_PANE, PanelStyles.PANEL_STYLE_BLUE50)
		rowListName = "CurrentPromotionList"
		screen.addMultiListControlGFC(rowListName, "", self.X_CURRENT_PROMO_PANE+15, self.Y_CURRENT_PROMO_PANE+40, self.W_CURRENT_PROMO_PANE-20, self.H_CURRENT_PROMO_PANE-40, 1, self.PROMOTION_ICON_SIZE, self.PROMOTION_ICON_SIZE, TableStyles.TABLE_STYLE_STANDARD)
		for k in range(gc.getNumPromotionInfos()):
			if (gc.getGame().getHeroPromotionStatus(iHero, k) == 1 or gc.getGame().getHeroPromotionStatus(iHero, k) == 2):
				screen.appendMultiListButton(rowListName, gc.getPromotionInfo(k).getButton(), 0, WidgetTypes.WIDGET_PEDIA_JUMP_TO_PROMOTION, k, -1, False)

		panelName = "PotentialPromotionPanel"
		screen.addPanel(panelName, localText.getText("TXT_KEY_PEDIA_CATEGORY_POTENTIAL_PROMOTION", ()), "", True, True, self.X_POTENTIAL_PROMO_PANE, self.Y_POTENTIAL_PROMO_PANE, self.W_POTENTIAL_PROMO_PANE, self.H_POTENTIAL_PROMO_PANE, PanelStyles.PANEL_STYLE_BLUE50)
		rowListName = "PotentialPromotionList"
		screen.addMultiListControlGFC(rowListName, "", self.X_POTENTIAL_PROMO_PANE+15, self.Y_POTENTIAL_PROMO_PANE+40, self.W_POTENTIAL_PROMO_PANE-20, self.H_POTENTIAL_PROMO_PANE-40, 1, self.PROMOTION_ICON_SIZE, self.PROMOTION_ICON_SIZE, TableStyles.TABLE_STYLE_STANDARD)
		for k in range(gc.getNumPromotionInfos()):
			if (isPromotionValid(k, gc.getHeroInfo(iHero).getUnitType(), False) and not gc.getPromotionInfo(k).isGraphicalOnly()):
				if (gc.getGame().getHeroPromotionStatus(iHero, k) == 3):
					screen.appendMultiListButton(rowListName, gc.getPromotionInfo(k).getButton(), 0, WidgetTypes.WIDGET_PEDIA_JUMP_TO_PROMOTION, k, -1, False)



	# returns a unique ID for a widget in this screen
	def getNextWidgetName(self):
		szName = self.WIDGET_ID + str(self.nWidgetCount * NUM_HERO_SCREENS + self.iScreen)
		self.nWidgetCount += 1
		return szName

	def getWidgetName(self, szBaseName):
		szName = szBaseName + str(self.iScreen)
		return szName

	def deleteAllWidgets(self):
		screen = self.getScreen()
		i = self.nWidgetCount - 1
		while (i >= 0):
			self.nWidgetCount = i
			screen.deleteWidget(self.getNextWidgetName())
			i -= 1

		self.nWidgetCount = 0

	# Handles the input for this screen...
	def handleInput (self, inputClass):
		if (inputClass.getNotifyCode() == NotifyCode.NOTIFY_CLICKED):
			if inputClass.getFunctionName() == "Recruit":
				CyMessageControl().sendModNetMessage(2, inputClass.getData1(), inputClass.getData2(), 0, -1)
				self.getScreen().hideScreen()
				return 1
			if inputClass.getFunctionName() == "SubScreen":
				if self.iScreen != inputClass.getID():
					self.iScreen = inputClass.getID()
					self.drawContents()
					return 1
			if inputClass.getFunctionName() == "HeroButton":
				screen = self.getScreen()
				functionName = "HeroButton" + str(inputClass.getID())
				if self.iHero != inputClass.getID():
					self.iHero = inputClass.getID()
					for iHero in self.PrisonerHeroes:
						screen.setState("HeroButton" + str(iHero), False)
					screen.setState(functionName, True)
					self.drawPediaContent(inputClass.getID())
					self.updateHandleButtons(self.iHero, 16, 10, 66)
					return 1
				else:
					screen.setState(functionName, True)
					return 1
			if inputClass.getFunctionName() == "Persuade":
				if self.iHero != -1:
					CyMessageControl().sendModNetMessage(6, self.iHero, self.iActiveLeader, -1, -1)
					self.updatePrisoners(self.iHero)
					return 1
				else:
					return 0
			if inputClass.getFunctionName() == "Execute":
				if self.iHero != -1:
					CyMessageControl().sendModNetMessage(7, self.iHero, self.iActiveLeader, -1, -1)
					self.updatePrisoners(self.iHero)
					return 1
				else:
					return 0
			if inputClass.getFunctionName() == "Release":
				if self.iHero != -1:
					CyMessageControl().sendModNetMessage(8, self.iHero, self.iActiveLeader, -1, -1)
					self.updatePrisoners(self.iHero)
					return 1
				else:
					return 0
			if inputClass.getFunctionName() == "Trade":
				if self.iHero != -1:
					self.getScreen().hideScreen()
					return 1
				else:
					return 0
		elif (inputClass.getNotifyCode() == NotifyCode.NOTIFY_LISTBOX_ITEM_SELECTED):
			if (inputClass.getFunctionName() + str(inputClass.getID()) == self.getWidgetName(self.DEBUG_DROPDOWN_ID)):
				print 'debug dropdown event'
				szName = self.getWidgetName(self.DEBUG_DROPDOWN_ID)
				iIndex = self.getScreen().getSelectedPullDownID(szName)
				self.iActiveLeader = self.getScreen().getPullDownData(szName, iIndex)
				self.drawContents()
				return 1

		return 0

	def update(self, fDelta):
		return
